<?php
/* --------------------------------------------------------------
   Withdrawals.php 2020-01-23
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\Withdrawal\Models;

use ArrayIterator;
use Gambio\Admin\Withdrawal\Interfaces\Withdrawal;
use Gambio\Admin\Withdrawal\Interfaces\Withdrawals as WithdrawalsInterface;
use Traversable;
use Webmozart\Assert\Assert;

/**
 * Class Withdrawals
 *
 * @package Gambio\Admin\Withdrawal\Models
 */
class Withdrawals implements WithdrawalsInterface
{
    /**
     * @var Withdrawal[]
     */
    private $withdrawals;
    
    
    /**
     * Withdrawals constructor.
     *
     * @param Withdrawal[] $withdrawals
     */
    private function __construct(array $withdrawals)
    {
        $this->withdrawals = $withdrawals;
    }
    
    
    /**
     * @param Withdrawal ...$withdrawals
     *
     * @return Withdrawals
     */
    public static function create(Withdrawal ...$withdrawals): Withdrawals
    {
        return new self($withdrawals);
    }
    
    
    /**
     * @param Withdrawal[] $withdrawals
     *
     * @return Withdrawals
     */
    public static function createWithReferences(array $withdrawals): Withdrawals
    {
        Assert::allIsInstanceOf($withdrawals,
                                Withdrawal::class,
                                'All items in provided list need to implement "' . Withdrawal::class . '".');
        
        return new self($withdrawals);
    }
    
    
    /**
     * Returns internal withdrawals as array iterator.
     *
     * @return Traversable
     */
    public function getIterator(): Traversable
    {
        return new ArrayIterator($this->withdrawals);
    }
    
    
    /**
     * Returns internal withdrawals as array.
     *
     * @return Withdrawal[]
     */
    public function items(): array
    {
        return $this->withdrawals;
    }
    
    
    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return $this->items();
    }
}